<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductDetailsModel extends Model
{
    use HasFactory;
    protected $table = 'product_details';
    protected $primaryKey = 'product_details_sid';
    protected $fillable = [
        'product_id',
        'product_details_code',
        'branch_id',
        'name',
        'native_name',
        'code',
        'category_id',
        'supplier_id',
        'unit_price',
        'qty',
        'description',
        'products_image',
        'margin_price',
        'status',
        'total_amount',
        'assembled_item_id',
        'purchase_id'
    ];

    public function payments()
    {
        return $this->hasMany(ProductPaymentModel::class, 'product_dtl_id');
    }

    public function paymentStatus()
    {
        return $this->belongsTo(PaymentStatusModel::class, 'status');
    }

    public function suppliers()
    {
        return $this->belongsTo(SupplierModel::class, 'supplier_id');
    }

    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }

    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
    public function purchase()
    {
        return $this->belongsTo(PurchaseModel::class, 'purchase_id');
    }
}
