@extends('layouts.layoutapp')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card me-2">
                <div class="card-header">
                    <div>
                        <h4>Inventory Report</h4>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table text-sm" id="myTable">
                            <thead>
                                <tr>
                                    <th class="text-center">Branch Name</th>
                                    <th class="text-center">Product Name</th>
                                    <th class="text-center">Category</th>
                                    <th class="text-center">Total Quantity</th>
                                    <th class="text-center">Total Available Quantity</th>
                                    <th class="text-center">Total Selling Quantity</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($product as $item)
                                    <tr>
                                        <td class="text-center">{{ $item->branch->name ?? '' }}</td>
                                        <td class="text-center">{{ $item->name ?? '' }}</td>
                                        <td class="text-center">
                                            {{ ($item->category->name ?? '') . (isset($item->category->unitOfMass) ? ' (' . $item->category->unitOfMass->name . ')' : '') }}
                                        </td>
                                        <td class="text-center">{{ $item->total_qty ?? '' }}</td>
                                        <td class="text-center">{{ $item->qty ?? '' }}</td>
                                        <td class="text-center">{{ max(0, round($item->total_qty - $item->qty, 0)) ?? '' }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection