<?php

use App\Http\Controllers\Api\MobAuthController;
use App\Http\Controllers\Api\MobCategoryController;
use App\Http\Controllers\Api\MobExpenseController;
use App\Http\Controllers\Api\MobInvoiceController;
use App\Http\Controllers\Api\MobInvoicePaymentController;
use App\Http\Controllers\Api\MobOrderController;
use App\Http\Controllers\Api\MobProductController;
use App\Http\Controllers\Api\MobPurchaseController;
use App\Http\Controllers\Api\MobPurchasePaymentController;
use App\Http\Controllers\Api\MobQuoteController;
use App\Http\Controllers\Api\MobSupplierController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/login', [MobAuthController::class, 'login']);

Route::middleware('auth:sanctum')->group(function () {

    Route::get('/invoices/payments', [MobInvoicePaymentController::class, 'getInvoicesWithPayments']);
    Route::get('/invoices/no-payments', [MobInvoicePaymentController::class, 'getInvoicesWithoutPayments']);
    Route::get('/companies', [MobAuthController::class, 'getCompanies']);
    Route::get('/companies/{id}/branches', [MobAuthController::class, 'getBranches']);
    Route::post('/setup', [MobAuthController::class, 'setup']);

    Route::prefix('suppliers')->group(function () {
        Route::get('/', [MobSupplierController::class, 'index']);
        Route::post('/', [MobSupplierController::class, 'store']);
        Route::put('/{id}', [MobSupplierController::class, 'update']);
        Route::delete('/{id}', [MobSupplierController::class, 'destroy']);
        Route::get('/all', [MobSupplierController::class, 'allSuppliers']);
    });

    Route::resource('products', MobProductController::class);
    Route::get('products/all/{branchId}', [MobProductController::class, 'allProducts']);
    Route::resource('quotes', MobQuoteController::class);
    Route::resource('categories', MobCategoryController::class);
    Route::get('expense-categories', [MobExpenseController::class, 'expenseCategory']);
    Route::resource('expenses', MobExpenseController::class);
    Route::resource('invoices', MobInvoiceController::class);


    Route::get('invoices/{invoiceId}/pdf', [MobInvoiceController::class, 'generateInvoice']);
    Route::get('taxes', [MobInvoiceController::class, 'getTaxes']);

    Route::prefix('payments')->group(function () {
        Route::post('/', [MobInvoicePaymentController::class, 'store']);
        Route::get('/{payment}', [MobInvoicePaymentController::class, 'show']);
        Route::put('/{payment}', [MobInvoicePaymentController::class, 'update']);
        Route::delete('/{payment}', [MobInvoicePaymentController::class, 'destroy']);
        Route::get('/invoice-details/{invoice}', [MobInvoicePaymentController::class, 'getInvoiceDetails']);
    });

    Route::get('orders/daily-requirements', [MobOrderController::class, 'getDailyRequirements']);
    Route::post('orders/temp-quantity', [MobOrderController::class, 'updateTempQuantity']);
    Route::get('orders/temp-quantities-for-purchase', [MobOrderController::class, 'getTempQuantitiesForPurchase']);
    Route::post('orders/convert-temp-to-purchase', [MobOrderController::class, 'convertTempToPurchase']);
    Route::post('/orders/check-client-by-phone', [MobOrderController::class, 'checkClientByPhone']);
    Route::resource('orders', MobOrderController::class);
    Route::get('/clients/addresses/{phone}', [MobOrderController::class, 'getClientAddress']);
    Route::get('/clients/numbers/{branchId}', [MobOrderController::class, 'getClients']);

    Route::get('/products-for-purchase', [MobPurchaseController::class, 'getProductsForPurchase']);
    Route::post('/purchases', [MobPurchaseController::class, 'store']);

     Route::get('/purchase-payments', [MobPurchasePaymentController::class, 'index']);
    Route::get('/purchase-payments/purchases-for-payment', [MobPurchasePaymentController::class, 'getPurchasesForPayment']);
    Route::post('/purchase-payments', [MobPurchasePaymentController::class, 'store']);
    Route::get('/purchase-payments/{id}', [MobPurchasePaymentController::class, 'show']);
    Route::post('/purchase-payments/add-payment', [MobPurchasePaymentController::class, 'addPayment']);
    Route::delete('/purchase-payments/{id}', [MobPurchasePaymentController::class, 'delete']);
});
