<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BOMItemsModel extends Model
{
    protected $table = 'bom_items';
    protected $primaryKey = 'id';
    protected $fillable = [
        'bom_id',
        'product_id',
        'uom_id',
        'qty',
        'unit_cost',
        'amount',
        'type',
        'description',
        'created_at',
        'updated_at',
    ];
    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }
    public function unit()
    {
        return $this->belongsTo(UomModel::class, 'uom_id');
    }

    public function costType()
    {
        return $this->belongsTo(CostTypeModel::class, 'type');
    }
}
