<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>EMO Process</title>
<link rel="icon" type="image/png" href="{{ asset('images/fav-icon.png') }}">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />


    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body class="font-sans antialiased bg-gray-100 text-gray-800">
    <div class="flex min-h-screen">

        {{-- Sidebar --}}
        <aside class="w-64 bg-white border-r flex flex-col">
            <div class="h-16 flex items-center justify-center font-bold text-xl border-b">
                EMO Process
            </div>
            <nav class="flex-1 p-4 space-y-1">
                <a href="{{ route('dashboard') }}" class="flex items-center gap-2 px-3 py-2 rounded-lg text-gray-700 hover:bg-blue-50 hover:text-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M3 12l9-9 9 9-9 9-9-9z"/></svg>
                    Dashboard
                </a>
                <a href="{{ route('emo.index') }}" class="flex items-center gap-2 px-3 py-2 rounded-lg text-gray-700 hover:bg-blue-50 hover:text-blue-600">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M4 6h16M4 12h16M4 18h16"/></svg>
                    EMO Uploads
                </a>
                
                <a href="{{ route('logout') }}" class="flex items-center gap-2 px-3 py-2 rounded-lg text-gray-700 hover:bg-blue-50 hover:text-blue-600">
        <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" 
                            class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                        Logout
                    </button>
                </form>
                    
                </a>
            </nav>
        </aside>

        {{-- Main Content Area --}}
        <div class="flex-1 flex flex-col">

            {{-- Top Navbar --}}
<header class="h-16 bg-white border-b shadow-sm flex items-center justify-between px-6">
    <div class="text-lg font-semibold">
        @isset($header) {{ $header }} @endisset
    </div>

    <div class="flex items-center gap-4">
       
        {{-- Profile Dropdown --}}
        <div x-data="{ open: false }" class="relative">
            <button @click="open = !open" class="flex items-center focus:outline-none">
                <img src="https://ui-avatars.com/api/?name={{ urlencode(Auth::user()->name ?? 'User') }}" 
                     class="w-9 h-9 rounded-full border" alt="User"/>
            </button>

            <div x-show="open" @click.away="open = false"
                 class="absolute right-0 mt-2 w-40 bg-white border rounded-lg shadow-lg py-2 z-50">
             
                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <button type="submit" 
                            class="w-full text-left px-4 py-2 text-sm text-red-600 hover:bg-gray-100">
                        Logout
                    </button>
                </form>
            </div>
        </div>
    </div>
</header>


            {{-- Page Content --}}
            <main class="flex-1 overflow-y-auto p-6 bg-gray-50">
                <div class="bg-white rounded-xl shadow-sm p-6">
                    {{ $slot }}
                </div>
            </main>

            {{-- Footer --}}
            <footer class="bg-white border-t text-center text-sm text-gray-500 py-4">
                © {{ date('Y') }} {{ config('app.name') }}. All rights reserved.
            </footer>
        </div>
    </div>
</body>
</html>
